/*----------------------------------------------------------------------------
 * Name:    led.c
 * Purpose: 
 * Note(s): 
 *----------------------------------------------------------------------------
 * This file is part of the uVision/ARM development tools.
 * This software may only be used under the terms of a valid, current,
 * end user licence from KEIL for a compatible version of KEIL software
 * development tools. Nothing else gives you the right to use this software.
 *
 * This software is supplied "AS IS" without warranties of any kind.
 *
 * Copyright (c) 2012 Keil - An ARM Company. All rights reserved.
 *----------------------------------------------------------------------------*/
#include	"led.h"
//#include  "main.h"

u16	LEDFlashTimer[4];	
u16	LEDFlashTmCnt[4];

u8 F_LED1 = 0;
u8 F_LED2 = 0;
u8 F_LED3 = 0;
u8 F_LED4 = 0;

u16 LED1_Counter = 0;
u16 LED2_Counter = 0;
u16 LED3_Counter = 0;
u16 LED4_Counter = 0;

u16 LED1_CounterLimit = 0;
u16 LED2_CounterLimit = 0;
u16 LED3_CounterLimit = 0;
u16 LED4_CounterLimit = 0;

/*****************************************************************************************************
* @brief  Configures LED I/O
* @retval None
*******************************************************************************************************/
void LED_IO_configure(void)																												
{
   /* configure LED1 as GPIO  */   
   AFIO_GPxConfig(LED1_PORT_NUM,(1UL << _LED1_IO_),AFIO_FUN_GPIO);
	 AFIO_GPxConfig(LED2_PORT_NUM,(1UL << _LED2_IO_),AFIO_FUN_GPIO);
	 AFIO_GPxConfig(LED3_PORT_NUM,(1UL << _LED3_IO_),AFIO_FUN_GPIO);
	 AFIO_GPxConfig(LED4_PORT_NUM,(1UL << _LED4_IO_),AFIO_FUN_GPIO);
   /* configure LED as OUT mode  */
   GPIO_DirectionConfig(LED1_PORT,(1UL << _LED1_IO_),GPIO_DIR_OUT);
	 GPIO_DirectionConfig(LED2_PORT,(1UL << _LED2_IO_),GPIO_DIR_OUT);
	 GPIO_DirectionConfig(LED3_PORT,(1UL << _LED3_IO_),GPIO_DIR_OUT);
	 GPIO_DirectionConfig(LED4_PORT,(1UL << _LED4_IO_),GPIO_DIR_OUT);
   /* configure LED driving current = 16mA  */
   GPIO_DriveConfig(LED1_PORT,(1UL << _LED1_IO_),GPIO_DV_16MA);
	 GPIO_DriveConfig(LED2_PORT,(1UL << _LED2_IO_),GPIO_DV_16MA);	
	 GPIO_DriveConfig(LED3_PORT,(1UL << _LED3_IO_),GPIO_DV_16MA);
   GPIO_DriveConfig(LED4_PORT,(1UL << _LED4_IO_),GPIO_DV_16MA);
	
	 LED1_OFF;
	 LED2_OFF;	
	 LED3_OFF;
	 LED4_OFF;	
}
/*****************************************************************************************************
* @brief  Configures LED I/O
* @retval None
*******************************************************************************************************/
void LED_always_on(u8 led)																										
{
	if(led == 1)		
	{
		LEDFlashTimer[0] = 0;
		LED1_ON;		
	}
	
	if(led == 2)
	{
		LEDFlashTimer[1] = 0;
		LED2_ON;
	}
	if(led == 3)		
	{
		LEDFlashTimer[2] = 0;
		LED3_ON;		
	}
	
	if(led == 4)
	{
		LEDFlashTimer[3] = 0;
		LED4_ON;
	}
}
/*****************************************************************************************************
* @brief  Configures LED I/O
* @retval None
*******************************************************************************************************/
void LED_always_off(u8 led)																										
{
	if(led == 1)				
	{
		LEDFlashTimer[0] = 0;
		LED1_OFF;		
	}
	
	if(led == 2)					
	{
		LEDFlashTimer[1] = 0;
		LED2_OFF;
	}
	if(led == 3)				
	{
		LEDFlashTimer[2] = 0;
		LED3_OFF;		
	}
	
	if(led == 4)					
	{
		LEDFlashTimer[3] = 0;
		LED4_OFF;
	}
}
/*****************************************************************************************************
* @brief  Configures LED I/O
* @retval None
*******************************************************************************************************/
void LED_flash_enable(u8 led,u16 timer)																							
{
	if(led == 1)					
	{
		LEDFlashTimer[0] = LEDFlashTmCnt[0] = timer;
		LED1_ON;		
	}	
	if(led == 2)				
	{
		LEDFlashTimer[1] = LEDFlashTmCnt[1] = timer;
		LED2_ON;
	}
	if(led == 3)					
	{
		LEDFlashTimer[2] = LEDFlashTmCnt[2] = timer;
		LED3_ON;		
	}	
	if(led == 4)				
	{
		LEDFlashTimer[3] = LEDFlashTmCnt[3] = timer;
		LED4_ON;
	}
}
/*****************************************************************************************************
* @brief  Configures LED I/O
* @retval None
*******************************************************************************************************/
void LED_flash_process(void)																									
{
	if(LEDFlashTimer[0])
	{
		if(--LEDFlashTmCnt[0] == 0)
		{
			LEDFlashTmCnt[0] = LEDFlashTimer[0];
			LED1_TOGGLE;																															  
		}
	}
	if(LEDFlashTimer[1])
	{
		if(--LEDFlashTmCnt[1] == 0)
		{
			LEDFlashTmCnt[1] = LEDFlashTimer[1];
			LED2_TOGGLE;
		}
	}	
	if(LEDFlashTimer[2])
	{
		if(--LEDFlashTmCnt[2] == 0)
		{
			LEDFlashTmCnt[2] = LEDFlashTimer[2];
			LED3_TOGGLE;
		}
	}
	if(LEDFlashTimer[3])
	{
		if(--LEDFlashTmCnt[3] == 0)
		{
			LEDFlashTmCnt[3] = LEDFlashTimer[3];
			LED4_TOGGLE;
		}
	}
}


/*****************************************************************************************************
* @brief  Set LED Flag and timer counter for LEDProcess_ms(); use
* @retval None
*******************************************************************************************************/
void LED_EnableFlag_ms(u8 led,u16 timer)
{
	if(led == 1)					
	{
		F_LED1 = 1;
		LED1_CounterLimit = timer;
	}	
	if(led == 2)				
	{
		F_LED2 = 1;
		LED2_CounterLimit = timer;
	}
	if(led == 3)					
	{
		F_LED3 = 1;
		LED3_CounterLimit = timer;	
	}	
	if(led == 4)				
	{
		F_LED4 = 1;
		LED4_CounterLimit = timer;
	}
}

/*****************************************************************************************************
* @brief  LED Process with timer
* @retval None
*******************************************************************************************************/
void LEDProcess_ms(void)
{	
	if(F_LED1 == 1)
	{
		LED1_ON;
		LED1_Counter++;
		if(LED1_Counter > LED1_CounterLimit)
		{
			F_LED1 = 0;
			LED1_Counter = 0;
		}
	}
	else
		LED1_OFF;
	
	if(F_LED2 == 1)
	{
		LED2_ON;
		LED2_Counter++;
		if(LED2_Counter > LED2_CounterLimit)
		{
			F_LED2 = 0;
			LED2_Counter = 0;
		}
	}
	else
		LED2_OFF;
	
	if(F_LED3 == 1)
	{
		LED3_ON;
		LED3_Counter++;
		if(LED3_Counter > LED3_CounterLimit)
		{
			F_LED3 = 0;
			LED3_Counter = 0;
		}
	}
	else
		LED3_OFF;
	
	if(F_LED4 == 1)
	{
		LED4_ON;
		LED4_Counter++;
		if(LED4_Counter > LED4_CounterLimit)
		{
			F_LED4 = 0;
			LED4_Counter = 0;
		}
	}
	else
		LED4_OFF;
	
}

/*****************************************************************************************************
* @brief  All LED ON
* @retval None
*******************************************************************************************************/
void LED_All_ON(void)
{
	LED1_ON;
	LED2_ON;	
	LED3_ON;
	LED4_ON;
}

/*****************************************************************************************************
* @brief  All LED OFF
* @retval None
*******************************************************************************************************/
void LED_All_OFF(void)
{
	LED1_OFF;
	LED2_OFF;	
	LED3_OFF;
	LED4_OFF;
}

